



#include <CompuCell3D/Simulator.h>
#include <CompuCell3D/Potts3D/Potts3D.h>
#include <CompuCell3D/Field3D/Field3D.h>
#include <CompuCell3D/Field3D/WatchableField3D.h>
#include <CompuCell3D/Boundary/BoundaryStrategy.h>

#include <CompuCell3D/Potts3D/CellInventory.h>
#include <CompuCell3D/Automaton/Automaton.h>
#include <BasicUtils/BasicString.h>
#include <BasicUtils/BasicException.h>
#include <PublicUtilities/StringUtils.h>

#include <iostream>
#include <string>
#include <algorithm>
#include <set>
#include <map>
#include <math.h>
using namespace CompuCell3D;


#include <iostream>
using namespace std;

#include "TCSFeedbackMapsSteppable.h"

TCSFeedbackMapsSteppable::TCSFeedbackMapsSteppable() : fieldG(0),sim(0),potts(0),xmlData(0),boundaryStrategy(0),automaton(0),cellInventoryPtr(0){}

TCSFeedbackMapsSteppable::~TCSFeedbackMapsSteppable() {
}


void TCSFeedbackMapsSteppable::init(Simulator *simulator, CC3DXMLElement *_xmlData) {

  xmlData=_xmlData;
  
  potts = simulator->getPotts();
  cellInventoryPtr=& potts->getCellInventory();
  automaton = potts->getAutomaton();
  fieldG = (WatchableField3D<CellG *> *)potts->getCellFieldG();

  simulator->registerSteerableObject(this);
    
     // define a new data-class (clusterData) for each cell:	
//     BasicClassAccessorBase * clusterDataAccessorPtr=&clusterDataAccessor;
// 	potts->getCellFactoryGroupPtr()->registerClass(clusterDataAccessorPtr); //this is to register the BasicclassAccessor to the large factory file

    bool boundaryPixelTrackerAlreadyRegisteredFlag;
    boundaryPixelTrackerPlugin=(BoundaryPixelTrackerPlugin*)Simulator::pluginManager.get("BoundaryPixelTracker",&boundaryPixelTrackerAlreadyRegisteredFlag);
    if (!boundaryPixelTrackerAlreadyRegisteredFlag){
            boundaryPixelTrackerPlugin->init(simulator);
    }
    
    bool pixelTrackerAlreadyRegisteredFlag;
    pixelTrackerPlugin=(PixelTrackerPlugin*)Simulator::pluginManager.get("PixelTracker",&pixelTrackerAlreadyRegisteredFlag);
    if (!pixelTrackerAlreadyRegisteredFlag){
            pixelTrackerPlugin->init(simulator);
    }
    
    bool clusterDataTrackerAlreadyRegisteredFlag;
	clusterDataTrackerPlugin=(ClusterDataTrackerPlugin*)Simulator::pluginManager.get("ClusterDataTrackerPlugin",&clusterDataTrackerAlreadyRegisteredFlag);
	if (!clusterDataTrackerAlreadyRegisteredFlag){
		clusterDataTrackerPlugin->init(simulator,_xmlData);
	}
        
    bool nTrackerAlreadyRegisteredFlag;
    nTrackerPlugin=(NeighborTrackerPlugin*)Simulator::pluginManager.get("NeighborTracker",&nTrackerAlreadyRegisteredFlag);
    if (!nTrackerAlreadyRegisteredFlag){
            nTrackerPlugin->init(simulator);
    }
    
    //rand function for probobality funtion, is class
    rand = BasicRandomNumberGenerator::getInstance();

    update(xmlData,true);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void TCSFeedbackMapsSteppable::extraInit(Simulator *simulator){
    //PUT YOUR CODE HERE

    FuPARact = simulator->getConcentrationFieldByName("uPARact");
    FVEGF = simulator->getConcentrationFieldByName("VEGF");

}  




void TCSFeedbackMapsSteppable::update(CC3DXMLElement *_xmlData, bool _fullInitFlag)
{
    boundaryStrategy=BoundaryStrategy::getInstance();
    //cerr<<"got here will do neighbor order"<<endl;
    if(_xmlData->getFirstElement("NeighborOrder"))
        maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(_xmlData->getFirstElement("NeighborOrder")->getUInt());	
    else
        maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(2);
 

//////////////////   modules parameters
    if(_xmlData->getFirstElement("DeltaT"))
        deltaT=_xmlData->getFirstElement("DeltaT")->getDouble();
    else
        deltaT=1.0;
 
    if(_xmlData->getFirstElement("OnlyAtBorder"))
        OnlyAtBorder=_xmlData->getFirstElement("OnlyAtBorder")->getDouble();
    else
        OnlyAtBorder=0.0;
    
    if(_xmlData->getFirstElement("OnlyAtBasolateral"))
        OnlyAtBasolateral=_xmlData->getFirstElement("OnlyAtBasolateral")->getDouble();
    else
        OnlyAtBasolateral=0.0;
    
    if(_xmlData->getFirstElement("contactCalculation"))
        contactCalculation=_xmlData->getFirstElement("contactCalculation")->getDouble();
    else
        contactCalculation=0.0;
  
    if(_xmlData->getFirstElement("negFBdelta"))
        negFBdelta=_xmlData->getFirstElement("negFBdelta")->getDouble();
    else
        negFBdelta=0.0;
    
    if(_xmlData->getFirstElement("posFBnotch"))
        posFBnotch=_xmlData->getFirstElement("posFBnotch")->getDouble();
    else
        posFBnotch=0.0;
    
    if(_xmlData->getFirstElement("cisSignal"))
        cisSignal=_xmlData->getFirstElement("cisSignal")->getDouble();
    else
        cisSignal=0.0;
        
    if(_xmlData->getFirstElement("VEGFfeedback"))
        VEGFfeedback=_xmlData->getFirstElement("VEGFfeedback")->getDouble();
    else
        VEGFfeedback=0.0;
    
    if(_xmlData->getFirstElement("VEGFR2haplo"))
        VEGFR2haplo=_xmlData->getFirstElement("VEGFR2haplo")->getDouble();
    else
        VEGFR2haplo=0.0;

    if(_xmlData->getFirstElement("scalingDim"))
        scalingDim=_xmlData->getFirstElement("scalingDim")->getDouble();
    else
        scalingDim=1.0;
////////////   notch parameters
    if(_xmlData->getFirstElement("bN"))
        bN=_xmlData->getFirstElement("bN")->getDouble();
    else
        bN=0.0;
    
    if(_xmlData->getFirstElement("gN"))
        gN=_xmlData->getFirstElement("gN")->getDouble();
    else
        gN=0.0;
    
    if(_xmlData->getFirstElement("aN"))
        aN=_xmlData->getFirstElement("aN")->getDouble();
    else
        aN=0.0;

    if(_xmlData->getFirstElement("kN"))
        kN=_xmlData->getFirstElement("kN")->getDouble();
    else
        kN=0.0;   
    
    if(_xmlData->getFirstElement("nN"))
        nN=_xmlData->getFirstElement("nN")->getDouble();
    else
        nN=0.0;     

////////// Delta parameters
    if(_xmlData->getFirstElement("bD"))
        bD=_xmlData->getFirstElement("bD")->getDouble();
    else
        bD=0.0;
    
    if(_xmlData->getFirstElement("bDc"))
        bDc=_xmlData->getFirstElement("bDc")->getDouble();
    else
        bDc=0.0;
    
    if(_xmlData->getFirstElement("gD"))
        gD=_xmlData->getFirstElement("gD")->getDouble();
    else
        gD=0.0;
    
    if(_xmlData->getFirstElement("aD"))
        aD=_xmlData->getFirstElement("aD")->getDouble();
    else
        aD=0.0;

    if(_xmlData->getFirstElement("kD"))
        kD=_xmlData->getFirstElement("kD")->getDouble();
    else
        kD=0.0;   
    
    if(_xmlData->getFirstElement("nD"))
        nD=_xmlData->getFirstElement("nD")->getDouble();
    else
        nD=0.0;   
  
    if(_xmlData->getFirstElement("mD"))
        mD=_xmlData->getFirstElement("mD")->getDouble();
    else
        mD=0.0;    

/////// cis trans
    if(_xmlData->getFirstElement("kc"))
        kc=_xmlData->getFirstElement("kc")->getDouble();
    else
        kc=0.0; 
    
    if(_xmlData->getFirstElement("kt"))
        kt=_xmlData->getFirstElement("kt")->getDouble();
    else
        kt=0.0; 

//////// notch-dll4 signal
    if(_xmlData->getFirstElement("gS"))
        gS=_xmlData->getFirstElement("gS")->getDouble();
    else
        gS=0.0;
    
    if(_xmlData->getFirstElement("aS"))
        aS=_xmlData->getFirstElement("aS")->getDouble();
    else
        aS=0.0;

    if(_xmlData->getFirstElement("kS"))
        kS=_xmlData->getFirstElement("kS")->getDouble();
    else
        kS=0.0;   
    
    if(_xmlData->getFirstElement("nS"))
        nS=_xmlData->getFirstElement("nS")->getDouble();
    else
        nS=0.0;     

//////////// uPAR parameters 
    if(_xmlData->getFirstElement("bU"))
        bU=_xmlData->getFirstElement("bU")->getDouble();
    else
        bU=0.0;
    
    if(_xmlData->getFirstElement("gU"))
        gU=_xmlData->getFirstElement("gU")->getDouble();
    else
        gU=0.0;
    
    if(_xmlData->getFirstElement("aU"))
        aU=_xmlData->getFirstElement("aU")->getDouble();
    else
        aU=0.0;

    if(_xmlData->getFirstElement("kU"))
        kU=_xmlData->getFirstElement("kU")->getDouble();
    else
        kU=0.0;   
    
    if(_xmlData->getFirstElement("nU"))
        nU=_xmlData->getFirstElement("nU")->getDouble();
    else
        nU=0.0;        
/////////////VEGFR2 parameters  
    if(_xmlData->getFirstElement("kv"))
        kv=_xmlData->getFirstElement("kv")->getDouble();
    else
        kv=0.0; 
    
    if(_xmlData->getFirstElement("bR"))
        bR=_xmlData->getFirstElement("bR")->getDouble();
    else
        bR=0.0;
    
    if(_xmlData->getFirstElement("bRc"))
        bRc=_xmlData->getFirstElement("bRc")->getDouble();
    else
        bRc=0.0;
    
    if(_xmlData->getFirstElement("gR"))
        gR=_xmlData->getFirstElement("gR")->getDouble();
    else
        gR=0.0;
    
    if(_xmlData->getFirstElement("aR"))
        aR=_xmlData->getFirstElement("aR")->getDouble();
    else
        aR=0.0;
    
    if(_xmlData->getFirstElement("kR"))
        kR=_xmlData->getFirstElement("kR")->getDouble();
    else
        kR=0.0;   
    
    if(_xmlData->getFirstElement("nR"))
        nR=_xmlData->getFirstElement("nR")->getDouble();
    else
        nR=0.0; 
    
    if(_xmlData->getFirstElement("mR"))
        mR=_xmlData->getFirstElement("mR")->getDouble();
    else
        mR=0.0;   
    
//////vegf-vegfr2 reporter parameters
    if(_xmlData->getFirstElement("gA"))
        gA=_xmlData->getFirstElement("gA")->getDouble();
    else
        gA=0.0;
    
    if(_xmlData->getFirstElement("aA"))
        aA=_xmlData->getFirstElement("aA")->getDouble();
    else
        aA=0.0;

    if(_xmlData->getFirstElement("kA"))
        kA=_xmlData->getFirstElement("kA")->getDouble();
    else
        kA=0.0;   
    
    if(_xmlData->getFirstElement("nA"))
        nA=_xmlData->getFirstElement("nA")->getDouble();
    else
        nA=0.0;   
   
    if(_xmlData->getFirstElement("nomVEGF"))
        nomVEGF=_xmlData->getFirstElement("nomVEGF")->getDouble();
    else
        nomVEGF=1.0;    
     
    
/////StructuredNoise
    if(_xmlData->getFirstElement("structuredNoiseDelta"))
        structuredNoiseDelta=_xmlData->getFirstElement("structuredNoiseDelta")->getDouble();
    else
        structuredNoiseDelta=0.0;  
    
    if(_xmlData->getFirstElement("structuredNoiseNotch"))
        structuredNoiseNotch=_xmlData->getFirstElement("structuredNoiseNotch")->getDouble();
    else
        structuredNoiseNotch=0.0;    
 
 
    
    
     //vector where the names of the types are stored
      
//       if(_xmlData->getFirstElement("types"))
//           {
//           string typeNamesString =_xmlData->getFirstElement("types")->getText();
//           //CC3D function that parses a string to a vector
//           parseStringIntoList(typeNamesString,typeNames, ","); //now typeNames should contain two elements, 'A' and 'B'
//           }


}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void TCSFeedbackMapsSteppable::start(){
   
}

std::map<long int,double>  TCSFeedbackMapsSteppable::getClusterNeighbors(long int clusterId)
    {

    map<long int,double> clusterNeighborIdsList;
    map<long int,CellG*> cellsInCluster=clusterDataTrackerPlugin->getCellsInClusterList(clusterId);
    map<long int,CellG*> ::iterator clusterIt;
    //start neigh search
    for ( clusterIt=cellsInCluster.begin() ; clusterIt != cellsInCluster.end(); ++clusterIt )
        {
        CellG *cell=(*clusterIt).second; 
        set<NeighborSurfaceData> *cellNeighborsPtr=0;
        neighborTrackerAccessorPtr=nTrackerPlugin->getNeighborTrackerAccessorPtr();
        cellNeighborsPtr = &(neighborTrackerAccessorPtr->get(cell->extraAttribPtr)->cellNeighbors);
        set<NeighborSurfaceData>::iterator sitr;    
        for(sitr=cellNeighborsPtr->begin() ; sitr != cellNeighborsPtr->end() ; ++sitr)
            {                       
            CellG *neighbor= sitr -> neighborAddress;    
            if (neighbor && (neighbor->clusterId!=cell->clusterId))
                {
                if(clusterDataTrackerPlugin->getIfEC(neighbor->clusterId))
                    {
                    if ( clusterNeighborIdsList.find(neighbor->clusterId) == clusterNeighborIdsList.end() )
                        {
                        clusterNeighborIdsList[neighbor->clusterId] = sitr->commonSurfaceArea;
                        }
                    else
                        {
                        clusterNeighborIdsList[neighbor->clusterId] += sitr->commonSurfaceArea;  
                        }
                    }
                }
            }  
        }
    return clusterNeighborIdsList;
    }  

void TCSFeedbackMapsSteppable::step(const unsigned int currentStep){
    //cerr<<"FeedbackSteppable"<<endl;
    set<long int> clusterIdsNoDelta; 
    set<long int> clusterIdsNoNotch; 
    set<long int> clusterIds=clusterDataTrackerPlugin->getClusterIdsList();   
    if (structuredNoiseNotch)
        {
        set<long int> ::iterator clusterIt;
        for ( clusterIt=clusterIds.begin() ; clusterIt != clusterIds.end(); ++clusterIt )
            {
            long int clusterId= *clusterIt; //key
            double randomD= rand->getRatio();  
            if (randomD<structuredNoiseNotch)
                clusterIdsNoNotch.insert(clusterId);
            }
          
        }
    if (structuredNoiseDelta)
        {
        set<long int> ::iterator clusterIt;
        for ( clusterIt=clusterIds.begin() ; clusterIt != clusterIds.end(); ++clusterIt )
            {
            long int clusterId= *clusterIt; //key
            double randomD= rand->getRatio();  
            if (randomD<structuredNoiseDelta)
                clusterIdsNoDelta.insert(clusterId);
            }
        }
    
    //initialize feedbackMap for each field
    
    
    //storeFeedback is a map with key is clusterId of cell and value is a map. In the value map are two items: list of basolat pixels and value of total uPARact change. This map is used in ApplyFeedbackStepplable after reactiondiffusion solver.
    cellAndFeedbackMap.clear();
    cellAndFeedbackPixelsSizeMap.clear();
    pixelVEGFFeedbackMap.clear();
    
    ////get each cluster of type EC
    set<long int> clusterIdList=clusterDataTrackerPlugin->getClusterIdsList();
    set<long int> ::iterator clusterIdListIt;
    for ( clusterIdListIt=clusterIdList.begin() ; clusterIdListIt != clusterIdList.end(); ++clusterIdListIt )
        {
        long int ownClusterId= *clusterIdListIt;
        //cerr<<"TCSF clusterId="<<ownClusterId;
        set<PixelTrackerData> pixelList;
        pixelList.clear();
        set<PixelTrackerData> pixelListErase;
        pixelListErase.clear();
        if(clusterDataTrackerPlugin->getIfEC(ownClusterId)) //if of type EC  
            {
            map<string,double> storeFeedbackMap;
            storeFeedbackMap.clear();
            double changeNotch=0.0;
            double changeDLL4=0.0; 
            double changeReporter=0.0;   
            double changeVEGFR2=0.0; 
            double changeVEGFreporter=0.0;  
            double changeUPAR=0.0;
                
                
//////////////////////////Get the VEGf concentration at border=membrane or basolateral membrane                
            if (VEGFfeedback)
                {                

                ////production of delta by VEGFreporter
                changeDLL4+=aD*((pow(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId),nD))/(kD+(pow(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId),nD))));
               //cerr<<"changeDLL4= "<<changeDLL4<<endl;       
                

               /////////////////changes in uPARact
                ////production of UPAR by VEGFreporter
                changeUPAR+=bU+(aU*((pow(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId),nU))/(kU+(pow(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId),nU)))))-(gU*(clusterDataTrackerPlugin->getuPARConcentration(ownClusterId)));
               //cerr<<"changeUPAR= "<<changeUPAR<<endl;    
        
                    
                    
                if(OnlyAtBorder || OnlyAtBasolateral) 
                    {

            //// get membrane pixels of cluster
                    pixelList=clusterDataTrackerPlugin->getBoundaryTrackerList(ownClusterId); 
                    //double count=newMembranePixelList.size();
                    }   
        ////get pixels of entire cell.          
                else
                    {
                    map<long int,CellG*> cellsInCluster=clusterDataTrackerPlugin->getCellsInClusterList(ownClusterId); //make a list of cells in this cluster
                    map<long int,CellG*>::iterator cellInClusterIt;    
                    for ( cellInClusterIt=cellsInCluster.begin() ; cellInClusterIt != cellsInCluster.end(); ++cellInClusterIt )
                        {

                        CellG *cell=(*cellInClusterIt).second;    
                        pixelTrackerAccessorPtr=pixelTrackerPlugin->getPixelTrackerAccessorPtr();
                        set<PixelTrackerData> pixelListCell=pixelTrackerAccessorPtr->get(cell->extraAttribPtr)->pixelSet; 
                        pixelList.insert(pixelListCell.begin(), pixelListCell.end()); 
                        }
                    }
                    
         ////iterate over pixels and calculate total VEGF concnetration
                double internalizationVEGFR2concentration=0.0; 
                double signalVEGF=0.0;
                set<PixelTrackerData>::iterator pixelListIt;
                for ( pixelListIt = pixelList.begin();pixelListIt != pixelList.end(); ++pixelListIt)
                    {
                    PixelTrackerData pixelD = *pixelListIt; 
                    Point3D pixel=Point3D(pixelD.pixel); 
                     
                    bool checkpixelConc=false;
                    if (OnlyAtBasolateral)
                        {
                        CellG *membranePixelCell=fieldG->get(pixel); 
                        if (membranePixelCell->type==automaton->getTypeId("basolat"))
                            { 
                            checkpixelConc=true;
                            }
                        else
                            {  
                            pixelListErase.insert(pixelD);
                            }
                        }
                    
                    else
                        {checkpixelConc=true;}
                    if (checkpixelConc)
                       {   
                        double internalizationVEGFpixel=0.0;
//                         if (changeUPAR) //then all these pixels need to be stored for update, not only VEGf pixels)
//                             {
//                             pixelVEGFFeedbackMap[pixelD]=internalizationVEGFpixel; 
//                             }
                        float VEGFconc=FVEGF->get(pixel)*nomVEGF;
                        if (VEGFconc)
                            {
                            //cerr<<"VEGFconc= "<<VEGFconc<<" VEGFR2conc="<<clusterDataTrackerPlugin->getVEGFR2Concentration(ownClusterId)<<" pixels#="<<pixelList.size()<<endl;
                            internalizationVEGFpixel-=(VEGFconc*(clusterDataTrackerPlugin->getVEGFR2Concentration(ownClusterId)/pixelList.size()))/kv;
                            //cerr<<"chanegVEGFconc= "<<internalizationVEGFpixel<<endl;  
                            ////store per pixel and substract from VEGF field in feedbackapplier
                            if (internalizationVEGFpixel)
                                {
                                pixelVEGFFeedbackMap[pixelD]=internalizationVEGFpixel*deltaT; 
                                }
                            
                            internalizationVEGFR2concentration-=internalizationVEGFpixel;
                            signalVEGF+=VEGFconc*(clusterDataTrackerPlugin->getVEGFR2Concentration(ownClusterId)/pixelList.size());
                            //cerr<<"loop signalVEGF= "<<signalVEGF<<endl;
                            }
                       }
                    }
                
                ////// calculate VEGF-VEGFR2 signal=VEGFreporter

                //double VEGFR2conc=clusterDataTrackerPlugin->getVEGFR2Concentration(ownClusterId); 
               // cerr<<"VEGFR2conc= "<<VEGFR2conc<<endl;
                //cerr<<"signalVEGF= "<<signalVEGF<<endl;
                changeVEGFreporter+=(aA * ((pow(signalVEGF,nA))/(kA+(pow(signalVEGF,nA)))))-(gA*(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId))); 
                //cerr<<"VEGFreporter="<<clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId)<<" changeVEGFreporter= "<<changeVEGFreporter<<endl; 
                    
                ///internalization of VEGFR2
                changeVEGFR2-=internalizationVEGFR2concentration ;
               //cerr<<"changeVEGFR2 internalization= "<<internalizationVEGFR2concentration<<endl;  

                

                }
            cellAndFeedbackPixelsSizeMap[ownClusterId]=pixelList.size()-pixelListErase.size();//need to know size of cell/membrane.basolat for upar distribution in applier  
            //cerr<<"list size= "<<cellAndFeedbackPixelsSizeMap[ownClusterId]<<endl;   

////////////////Sprinzak code for delta/notch reactions                      
//             /////notch signal calculation by sprinzak (take average delta/notch concentration of neighbors)
            if (!contactCalculation)
                {
                double interactingDeltaTotal=0.0;
                double interactingNotchTotal=0.0;
                double neighbourcount=0.0;
                    
                map<long int,double>  neighboringClusterIds=getClusterNeighbors(ownClusterId);
                map<long int,double> ::iterator neighclusterIt;
                for ( neighclusterIt=neighboringClusterIds.begin() ; neighclusterIt != neighboringClusterIds.end(); ++neighclusterIt )
                    {
                    long int neighClusterId=(*neighclusterIt).first; 
                    if (structuredNoiseDelta && (clusterIdsNoDelta.find(neighClusterId) != clusterIdsNoDelta.end())) //This cell will not give inhibtion to neighbors  
                        interactingDeltaTotal+=0;
                    else 
                        interactingDeltaTotal+=clusterDataTrackerPlugin->getDeltaConcentration(neighClusterId);
                    interactingNotchTotal+=clusterDataTrackerPlugin->getNotchConcentration(neighClusterId);
                    //cerr<<"interactingDeltaTotal= "<<interactingDeltaTotal<<" interactingNotchTotal= "<<interactingNotchTotal<<endl;
                    neighbourcount+=1;
                    }
                double interactingDeltaNeigh=(interactingDeltaTotal/neighbourcount);
                double interactingNotchNeigh=(interactingNotchTotal/neighbourcount);
                //cerr<<"interactingDeltaNeigh= "<<interactingDeltaNeigh<<" interactingNotchNeigh= "<<interactingNotchNeigh<<endl;
                ///change Reporter 

                double cellNotchLevel=clusterDataTrackerPlugin->getNotchConcentration(ownClusterId);     
                if (structuredNoiseNotch) //This cell will not react to its inhibition by neighbors
                    {
                    if (clusterIdsNoNotch.find(ownClusterId) != clusterIdsNoNotch.end())   
                        cellNotchLevel=0;
                    } 
                changeReporter+=(aS* pow(cellNotchLevel*interactingDeltaNeigh,nS)/(kS+pow(cellNotchLevel*interactingDeltaNeigh,nS)))-(gS*(clusterDataTrackerPlugin->getReporterConcentration(ownClusterId)));

                //cerr<<"changeReporter= "<<changeReporter<<endl; 
                ///loss by transsignal
                changeNotch-=(cellNotchLevel*interactingDeltaNeigh)/kt;   
                changeDLL4-=(clusterDataTrackerPlugin->getDeltaConcentration(ownClusterId)*interactingNotchNeigh)/kt;    
                    //cerr<<"changeNotch= "<<changeNotch<<endl; 
                    //cerr<<"changeDLL4= "<<changeDLL4<<endl; 
                }
                
////Adaption of sprinzak in which responder and trans depend on contact between cells
////////////////////////////////////////
            /////neighbors notch signal calculation by cell-cell contact (take ratio of contact/total membrane of the receptors)
            if (contactCalculation)
                {
                double interactingDeltaCell=0.0;
                double interactingNotchCell=0.0;
                double interactingDeltaNeigh=0.0;
                double interactingNotchNeigh=0.0;
                map<long int,double>  neighboringClusterIds=getClusterNeighbors(ownClusterId);
                map<long int,double> ::iterator neighclusterIt;
                for ( neighclusterIt=neighboringClusterIds.begin() ; neighclusterIt != neighboringClusterIds.end(); ++neighclusterIt )
                    {
                    long int neighClusterId=(*neighclusterIt).first; 
                    double commonSurfaceArea=(*neighclusterIt).second/2; //devide by two since it is added membrane of both cells
                   // cerr<<"neigh= "<<neighClusterId<<" commonSurfaceArea= "<<commonSurfaceArea<<endl;
                  //  cerr<<"neigh boundary= "<<(clusterDataTrackerPlugin->getBoundaryTrackerList(neighClusterId)).size()<<" cell bounary= "<<(clusterDataTrackerPlugin->getBoundaryTrackerList(ownClusterId)).size()<<endl;
                    //cerr<<"neigh delta= "<<neighClusterId<<" cell notch= "<<clusterDataTrackerPlugin->getNotchConcentration(ownClusterId)<<endl;
                    interactingDeltaCell+=clusterDataTrackerPlugin->getDeltaConcentration(ownClusterId)* (commonSurfaceArea/(clusterDataTrackerPlugin->getBoundaryTrackerList(ownClusterId)).size());
                    if (structuredNoiseDelta && (clusterIdsNoDelta.find(neighClusterId) != clusterIdsNoDelta.end())) //This cell will not give inhibtion to neighbors  
                        interactingDeltaNeigh+=0;
                    else
                        interactingDeltaNeigh+=clusterDataTrackerPlugin->getDeltaConcentration(neighClusterId)* (commonSurfaceArea/(clusterDataTrackerPlugin->getBoundaryTrackerList(neighClusterId)).size());
                    interactingNotchCell+=clusterDataTrackerPlugin->getNotchConcentration(ownClusterId)* (commonSurfaceArea/(clusterDataTrackerPlugin->getBoundaryTrackerList(ownClusterId)).size());
                    interactingNotchNeigh+=clusterDataTrackerPlugin->getNotchConcentration(neighClusterId)* (commonSurfaceArea/(clusterDataTrackerPlugin->getBoundaryTrackerList(neighClusterId)).size());
                  //  cerr<<"interactingDeltaCell= "<<interactingDeltaCell<<" interactingNotchCell= "<<interactingNotchCell<<endl;
                  //  cerr<<"interactingDeltaNeigh= "<<interactingDeltaNeigh<<" interactingNotchNeigh= "<<interactingNotchNeigh<<endl;
                    }
            ////scaling dimensions
                interactingDeltaCell/=scalingDim;
                interactingNotchCell/=scalingDim;
                if (structuredNoiseNotch)
                    if (clusterIdsNoNotch.find(ownClusterId) != clusterIdsNoNotch.end())
                        interactingNotchCell=0;
                interactingDeltaNeigh/=scalingDim;
                interactingNotchNeigh/=scalingDim;        
            ///change Reporter 
            changeReporter+=(aS* pow(interactingNotchCell*interactingDeltaNeigh,nS)/(kS+pow(interactingNotchCell*interactingDeltaNeigh,nS)))-(gS*(clusterDataTrackerPlugin->getReporterConcentration(ownClusterId)));
              // cerr<<"changeReporter= "<<changeReporter<<endl; 
            
            ///loss by transsignal
            changeNotch-=(interactingNotchCell*interactingDeltaNeigh)/kt;   
            changeDLL4-=(interactingDeltaCell*interactingNotchNeigh)/kt;    
              // cerr<<"changeNotch= "<<changeNotch<<endl; 
              //  cerr<<"changeDLL4= "<<changeDLL4<<endl; 
             
                }
                
            ///loss by cis-signall 
            if (cisSignal)
                {
                changeNotch-=(clusterDataTrackerPlugin->getDeltaConcentration(ownClusterId)*clusterDataTrackerPlugin->getNotchConcentration(ownClusterId))/kc;   
                changeDLL4-=(clusterDataTrackerPlugin->getDeltaConcentration(ownClusterId)*clusterDataTrackerPlugin->getNotchConcentration(ownClusterId))/kc;
                }
                
            ///decay cellvalues
            changeNotch-=clusterDataTrackerPlugin->getNotchConcentration(ownClusterId)*gN;   
            changeDLL4-=clusterDataTrackerPlugin->getDeltaConcentration(ownClusterId)*gD;
                
            if (VEGFfeedback)
                {    
                ///inhibition vegfr2 by notch signal, while stimulated by bR and self-feedback by function of A
                CellG* cell=clusterDataTrackerPlugin->getCytoplasmCell(ownClusterId);
                if ((cell->type==automaton->getTypeId("tipcell"))||(cell->type==automaton->getTypeId("cell")))
                    {
                    changeVEGFR2+=bRc;
                    changeVEGFR2+=((1/(1+pow(clusterDataTrackerPlugin->getReporterConcentration(ownClusterId),mR)))*bR); 
                    changeVEGFR2+=(aR*((pow(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId),nR))/(kR+(pow(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId),nR))))); 
                    }
                else
                    {
                    if (VEGFR2haplo)
                        {
                        changeVEGFR2+=bRc/2;
                        changeVEGFR2+=((1/(1+pow(clusterDataTrackerPlugin->getReporterConcentration(ownClusterId),mR)))*bR)/2; 
                        changeVEGFR2+=(aR*((pow(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId),nR))/(kR+(pow(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId),nR)))))/4; 
                        }
                    else
                        {
                        changeVEGFR2+=bRc;
                        changeVEGFR2+=((1/(1+pow(clusterDataTrackerPlugin->getReporterConcentration(ownClusterId),mR)))*bR); 
                        changeVEGFR2+=(aR*((pow(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId),nR))/(kR+(pow(clusterDataTrackerPlugin->getVEGFreporterConcentration(ownClusterId),nR))))); 
                        }
                    }
                    //decay vegfr2
                changeVEGFR2-=gR*clusterDataTrackerPlugin->getVEGFR2Concentration(ownClusterId);
                }
            if (posFBnotch)
                {
                //changeNotch+=notchProductionConstant+ (reporterProductionConstant* pow((clusterDataTrackerPlugin->getNotchConcentration(ownClusterId))*interactingDeltaNeigh,factorN)/(factorK+pow((clusterDataTrackerPlugin->getNotchConcentration(ownClusterId))*interactingDeltaNeigh,factorN)));  
                changeNotch+=bN+ (aN* pow(clusterDataTrackerPlugin->getReporterConcentration(ownClusterId),nN)/(kN+pow(clusterDataTrackerPlugin->getReporterConcentration(ownClusterId),nN)));  
                changeDLL4+=bD;  
                }
            if (negFBdelta)
                {
                changeNotch+=bN;   
                changeDLL4+=bDc+(bD * (1/(1+pow(clusterDataTrackerPlugin->getReporterConcentration(ownClusterId),mD))));  
                }
            if (!posFBnotch && !negFBdelta)
                {
                changeNotch+=bN;   
                changeDLL4+=bD;      
                }
            
            

///////////////////////////////////////////          
          
            ////store feedbacks
            storeFeedbackMap["Notch"]=changeNotch*deltaT;    
            storeFeedbackMap["DLL4"]=changeDLL4*deltaT;
            storeFeedbackMap["reporter"]=changeReporter*deltaT;            
            storeFeedbackMap["VEGFR2"]=changeVEGFR2*deltaT;
            storeFeedbackMap["VEGFreporter"]=changeVEGFreporter*deltaT;
            storeFeedbackMap["uPAR"]=changeUPAR*deltaT;
            cellAndFeedbackMap[ownClusterId]=storeFeedbackMap;  
            
            }  
        } 

 
}
std::string TCSFeedbackMapsSteppable::toString(){
   return "TCSFeedbackMapsSteppable";
}

std::string TCSFeedbackMapsSteppable::steerableName(){
   return toString();
}
        